﻿©Fluke                                                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub IVI DC Power Constants
DATE:                  2011-08-01 13:45:39
AUTHOR:                Fluke
REVISION:              $Revision: 1.1 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       198
=============================================================================
#
# Text Source:
#   $RCSfile: sub_ivi_dc_pwr_constants.txt,v $
#   $Date: 2011/08/03 22:45:54 $
#
# Procedure Author(s):
#       DAC
#
# Source:
#       I V I - D C P W R
#       ©2000-2009 National Instruments.  All Rights Reserved.
#       Title:       ividcpwr.h
#       Purpose:     IviDCPwr Class declarations for the Base and Extended
#
# Compatibility:
#       MET/CAL 8.0
#
#  Subprocedures:
#       Sub IVI Constants
#
#  Required Files:
#       None
#
#  Additional Equipment Required:
#       None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  CALL         Sub IVI Constants

#*- Defined values for rangeType parameter of function -*
#*- IviDCPwr_ConfigureOutputRng -*
  1.002  MATH         @iviDCPwrValRngCurr = 0
  1.003  MATH         @iviDCPwrValRngVolt = 1

  1.004  MATH         @iviDCPwrValRngTypeClassExtBase = 500
  1.005  MATH         @iviDCPwrValRngTypeSpecExtBase  = 1000

#*- Defined values for outputState parameter of function -*
#*- IviDCPwr_QueryOutputState -*
  1.006  MATH         @iviDCPwrValOutConstVolt   = 0
  1.007  MATH         @iviDCPwrValOutConstCurr   = 1
  1.008  MATH         @iviDCPwrValOutOverVolt    = 2
  1.009  MATH         @iviDCPwrValOutOverCurr    = 3
  1.010  MATH         @iviDCPwrValOutUnregulated = 4

  1.011  MATH         @iviDCPwrValOutStateClassExtBase = 500
  1.012  MATH         @iviDCPwrValOutStateSpecExtBase  = 1000

#*- Defined values for measurementType parameter of function -*
#*- IviDCPwr_Measure -*
  1.013  MATH         @iviDCPwrValMeasCurr = 0
  1.014  MATH         @iviDCPwrValMeasVolt = 1

  1.015  MATH         @iviDCPwrValMeasClassExtBase = 500
  1.016  MATH         @iviDCPwrValMeasSpecExtBase  = 1000

#****************************************************************************
#*------------------ IviDCPwr Class Attribute Defines ----------------------*
#****************************************************************************

#*- IVI Inherent Attributes -*
#*- User Options -*
  1.017  MATH         @iviDCPwrAttrCache           = @iviAttrCache
  1.018  MATH         @iviDCPwrAttrRngChk          = @iviAttrRngChk
  1.019  MATH         @iviDCPwrAttrQueryInstrStat  = @iviAttrQueryInstrStat
  1.020  MATH         @iviDCPwrAttrRecCoercions    = @iviAttrRecCoercions
  1.021  MATH         @iviDCPwrAttrSim             = @iviAttrSim
  1.022  MATH         @iviDCPwrAttrInterchangeChk  = @iviAttrInterchangeChk
  1.023  MATH         @iviDCPwrAttrSpy             = @iviAttrSpy
  1.024  MATH         @iviDCPwrAttrUseSpecSim      = @iviAttrUseSpecSim

#*- Instrument Capabilities -*
  1.025  MATH         Temp = @iviAttrGroupCapabilities
  1.026  MATH         @iviDCPwrAttrGroupCapabilities = Temp
  1.027  MATH         Temp = @iviAttrFuncCapabilities
  1.028  MATH         @iviDCPwrAttrFuncCapabilities  = Temp

#*- Class Driver Information -*
  1.029  MATH         Temp = @iviAttrClassDrvPrefix
  1.030  MATH         @iviDCPwrAttrClassDrvPrefix = Temp
  1.031  MATH         @iviDCPwrAttrClassDrvVendor = @iviAttrClassDrvVendor
  1.032  MATH         @iviDCPwrAttrClassDrvDescr  = @iviAttrClassDrvDescr
#        MATH         Temp = @iviAttrClassDrvClassSpecMajorVer
#        MATH         @iviDCPwrAttrClassDrvClassSpecMajorVer = Temp
#        MATH         Temp = @iviAttrClassDrvClassSpecMinorVer
#        MATH         @iviDCPwrAttrClassDrvClassSpecMinorVer = Temp

#*- Spec Driver Information -*
  1.033  MATH         Temp = @iviAttrSpecificDrvPrefix
  1.034  MATH         @iviDCPwrAttrSpecificDrvPrefix = Temp
  1.035  MATH         Temp = @iviAttrSpecificDrvLocator
  1.036  MATH         @iviDCPwrAttrSpecificDrvLocator = Temp
  1.037  MATH         Temp = @iviAttrIOResourceDescriptor
#        MATH         @iviDCPwrAttrIOResourceDescriptor = Temp
  1.038  MATH         @iviDCPwrAttrLogicalName        = @iviAttrLogicalName
  1.039  MATH         Temp = @iviAttrSpecificDrvVendor
  1.040  MATH         @iviDCPwrAttrSpecificDrvVendor      = Temp
  1.041  MATH         Temp = @iviAttrSpecificDrvDescr
  1.042  MATH         @iviDCPwrAttrSpecificDrvDescr       = Temp
#        MATH         Temp = @iviAttrSpecificDrvClassSpecificMajorVer
#        MATH         @iviDCPwrAttrSpecDrvClassSpecificMajorVer = Temp
#        MATH         Temp = @iviAttrSpecificDrvClassSpecificMinorVer
#        MATH         @iviDCPwrAttrSpecificDrvClassSpecificMinorVer = Temp

#*- Instrument Information -*
  1.043  MATH         @iviDCPwrAttrInstrFirmwareRev = @iviAttrInstrFirmwareRev
  1.044  MATH         Temp = @iviAttrInstrManufacturer
  1.045  MATH         @iviDCPwrAttrInstrManufacturer = Temp
  1.046  MATH         @iviDCPwrAttrInstrModel       = @iviAttrInstrModel
  1.047  MATH         Temp = @iviAttrSupportedInstrModels
#        MATH         @iviDCPwrAttrSupportedInstrModels = Temp

#*- Version Information -*
  1.048  MATH         @iviDCPwrAttrClassDrvRev = @iviAttrClassDrvRev

  1.049  MATH         @iviDCPwrAttrSpecificDrvRev = @iviAttrSpecificDrvRev

#*- Driver Setup information -*
  1.050  MATH         @iviDCPwrAttrDrvSetup = @iviAttrDrvSetup

#*- IviDCPwr Fundamental Attributes -*
  1.051  MATH         @iviDCPwrAttrChanCount       = @iviAttrChanCount
  1.052  MATH         AttrBase = @iviClassPublicAttrBase
  1.053  MATH         @iviDCPwrAttrVoltLvl         = AttrBase + 1
  1.054  MATH         @iviDCPwrAttrOVPEnabled      = AttrBase + 2
  1.055  MATH         @iviDCPwrAttrOVPLmt          = AttrBase + 3
  1.056  MATH         @iviDCPwrAttrCurrLmtBehavior = AttrBase + 4
  1.057  MATH         @iviDCPwrAttrCurrLmt         = AttrBase + 5
  1.058  MATH         @iviDCPwrAttrOutEnabled      = AttrBase + 6

#*- IviDCPwr Extended Attributes -*
#*- Trigger Attributes -*
  1.059  MATH         @iviDCPwrAttrTrigSrc     = AttrBase + 101
  1.060  MATH         @iviDCPwrAttrTrigCurrLmt = AttrBase + 102
  1.061  MATH         @iviDCPwrAttrTrigVoltLvl = AttrBase + 103

#****************************************************************************
#*----------------- IviDCPwr Class Attribute Value Defines -----------------*
#****************************************************************************

#*- Defined values for attribute iviDCPwrAttrCurrLmtBehavior -*
  1.062  MATH         @iviDCPwrValCurrRegulate = 0
  1.063  MATH         @iviDCPwrValCurrTrip     = 1

#        MATH         @iviDCPwrValCurrLmtBehaviorClassExtBase = 500
#        MATH         @iviDCPwrValCurrLmtBehaviorSpecExtBase  = 1000

#*-  Defined values for attribute iviDCPwrAttrTrigSrc -*
  1.064  MATH         @iviDCPwrValTrigImmediate = 0
  1.065  MATH         @iviDCPwrValTrigExt       = 1
  1.066  MATH         @iviDCPwrValSoftwareTrig  = 2
  1.067  MATH         @iviDCPwrValTrigTTL0      = 3
  1.068  MATH         @iviDCPwrValTrigTTL1      = 4
  1.069  MATH         @iviDCPwrValTrigTTL2      = 5
  1.070  MATH         @iviDCPwrValTrigTTL3      = 6
  1.071  MATH         @iviDCPwrValTrigTTL4      = 7
  1.072  MATH         @iviDCPwrValTrigTTL5      = 8
  1.073  MATH         @iviDCPwrValTrigTTL6      = 9
  1.074  MATH         @iviDCPwrValTrigTTL7      = 10
  1.075  MATH         @iviDCPwrValTrigECL0      = 11
  1.076  MATH         @iviDCPwrValTrigECL1      = 12
  1.077  MATH         @iviDCPwrValTrigPXIStar   = 13
  1.078  MATH         @iviDCPwrValTrigRTSI_0    = 14
  1.079  MATH         @iviDCPwrValTrigRTSI_1    = 15
  1.080  MATH         @iviDCPwrValTrigRTSI_2    = 16
  1.081  MATH         @iviDCPwrValTrigRTSI_3    = 17
  1.082  MATH         @iviDCPwrValTrigRTSI_4    = 18
  1.083  MATH         @iviDCPwrValTrigRTSI_5    = 19
  1.084  MATH         @iviDCPwrValTrigRTSI_6    = 20

  1.085  MATH         @iviDCPwrValTrigSrcClassExtBase    = 500
  1.086  MATH         @iviDCPwrValTrigSrcSpecExtBase = 1000

  1.087  END
